#ifndef _CUSTOMGUI_BITMAPBUTTON_H_
#define _CUSTOMGUI_BITMAPBUTTON_H_

#ifdef _INTERNAL_BITMAPBUTTON_
	#define _INTERNAL_BASECUSTOM_
#endif

#include "customgui_base.h"
#include "c4d_basecontainer.h"
#include "c4d_customdatatype.h"
#include "lib_description.h"

#define CUSTOMGUI_BITMAPBUTTON			1000479 
#define CUSTOMDATATYPE_BITMAPBUTTON 1001053

#define BITMAPBUTTON_BORDER								'brdr'
#define BITMAPBUTTON_BUTTON								'butt'
#define BITMAPBUTTON_TOGGLE								'togg'
#define BITMAPBUTTON_IGNORE_BITMAP_WIDTH	'ignw'
#define BITMAPBUTTON_IGNORE_BITMAP_HEIGTH	'ignh'
#define BITMAPBUTTON_DRAWPOPUPBUTTON			'popu'

class BaseList2D;

class BitmapButtonStruct : public iCustomDataType<BitmapButtonStruct>
{
	public:
		BitmapButtonStruct() { op=NULL; dirty=reserved=0; }
		BitmapButtonStruct(BaseList2D *t_op, const DescID &t_id, LONG t_dirty) { op=t_op; id=t_id; dirty=t_dirty; reserved=0; }
	
		BaseList2D	*op;
		DescID			id;
		LONG				dirty;
		LONG				reserved;
};

class BitmapButtonCustomGui : public BaseCustomGui<CUSTOMGUI_BITMAPBUTTON>
{
		BitmapButtonCustomGui();

	public:

		Bool SetImage(BaseBitmap *bmp,Bool copybmp,Bool secondstate=FALSE);
		Bool SetImage(const Filename &name,Bool secondstate=FALSE);
		void SetToggleState(Bool set);
		void SetDragArray(AtomArray *bl);
};





// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#ifndef _INTERNAL_BITMAPBUTTON_
	class iBitmapButtonCustomGui : public iBaseCustomGui
	{
	};
#else
	class iBitmapButtonCustomGui;
#endif

struct BitmapButtonLib : public BaseCustomGuiLib
{
	Bool		(iBitmapButtonCustomGui::*SetImageA			)(BaseBitmap *bmp,Bool copybmp,Bool secondstate);
	Bool		(iBitmapButtonCustomGui::*SetImageB			)(const Filename &name,Bool secondstate);
	void		(iBitmapButtonCustomGui::*SetToggleState)(Bool set);
	void		(iBitmapButtonCustomGui::*SetDragArray	)(AtomArray *bl);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
